#!/bin/bash

WORKDIR=$(cd "$(dirname "$0")"; pwd)

echo
echo "Current Working Directory:"
echo $WORKDIR
echo

DEBPATH=""$WORKDIR"/katusha-m335-package_1.0.2_amd64.deb"

echo "DEB Path:"
echo "$DEBPATH"
echo

sudo dpkg -i "$DEBPATH"
sudo service cups restart
sudo udevadm control --reload-rules && sudo udevadm trigger --subsystem-match=usb --action=add

echo
echo "*==================================================*"
echo "*  Installing the printer & scanner driver package *"
echo "*  for M335 Series.                                *"
echo "*                                                  *"
echo "*  Completed.                                      *"
echo "*==================================================*"
echo

sleep 1

